﻿# Author Jörn Walter 2016
# Website https://www.der-windows-papst.de
[void][reflection.assembly]::Load("System.Windows.Forms, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089")
$testfolder = Test-Path $Env:LocalAppData"\Microsoft\Outlook\*.ost"
if ( $testfolder -eq $false ){
[void][System.Windows.Forms.MessageBox]::Show("Der Pfad oder die Datei existieren nicht","Hinweis")
exit
}
$ostsize = Get-ChildItem -Recurse $Env:LocalAppData"\Microsoft\Outlook\*.ost" | Measure-Object -property length -sum
[int]$DataFilesize = ( ($ostsize.sum)   / 1MB )

$OstPath = $Env:LocalAppData + "\Microsoft" + "\Outlook" 
$ost = get-ChildItem $OstPath | where { $_.Extension -eq ".ost"
}
$Result = [System.Windows.Forms.MessageBox]::Show("Soll die Datei wirklich gelöscht werden?","Sicherheitsabfrage",1)
 If ($Result -eq "OK")
 {
 $ost | remove-Item
[void][System.Windows.Forms.MessageBox]::Show("Die Datei wurde gelöscht und hatte eine Größe von $DataFilesize MB","Hinweis")
}

else {
# Keine Aktion
}